﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Security.Principal;
using System.Windows.Threading;
using System.Threading;
using System.Runtime.InteropServices;
using VistaBridge.UI;
using Ayakawa.FormUtils;
using Ayakawa.MonitorTools;
using System.Windows.Interop;
using Microsoft.Win32;
using Ayakawa.DotNetRuntimeUpdateCheker;

namespace AyaClock.WPF
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    
    public partial class MainWindow : Window
    {

        [StructLayout(LayoutKind.Sequential, Pack = 1)]
        private struct MEMORYSTATUSEX
        {
            public UInt32 dwLength;
            public UInt32 dwMemoryLoad;
            public UInt64 ullTotalPhys;
            public UInt64 ullAvailPhys;
            public UInt64 ullTotalPageFile;
            public UInt64 ullAvailPageFile;
            public UInt64 ullTotalVirtual;
            public UInt64 ullAvailVirtual;
            public UInt64 ullAvailExtendedVirtual;
        }

        [DllImport("kernel32.dll", SetLastError = true)]
        private static extern bool GlobalMemoryStatusEx(ref MEMORYSTATUSEX lpBuffer);

        /// <summary>
        /// 表示設定用プロパティ群
        /// </summary>
        /// 
        private void SafetySaveConfig() // より安全なconfig saveing
        { 
            if (!SystemShutdownFlag)
            {
                AyaClockConfig.SaveConfig();
            }
        }

        private bool _StayOnTop;
        private bool StayOnTop
        {
            get { return _StayOnTop; }
            set
            {
                if (this._StayOnTop == value) return;
                this._StayOnTop = value;
                this.Topmost = this._StayOnTop;
                AyaClockConfig.Instance.StayOnTop = this._StayOnTop;
                SafetySaveConfig();
            }
        }

        private bool _IgnoreTaskBar;
        private bool IgnoreTaskBar
        {
            get { return _IgnoreTaskBar; }
            set
            {
                if (this._IgnoreTaskBar == value) return;
                this._IgnoreTaskBar = value;
                FormUtils.AdjustWindowPos(this, PosType, this._IgnoreTaskBar);
                AyaClockConfig.Instance.IgnoreTaskBar = this._IgnoreTaskBar;
                SafetySaveConfig();
            }
        }

        private PositionType _PosType;
        private void PosMnChecked(MenuItem CheckedMn)
        {
            LeftTopMn.IsChecked = LeftTopMn.Equals(CheckedMn);
            LeftBottomMn.IsChecked = LeftBottomMn.Equals(CheckedMn);
            RightTopMn.IsChecked = RightTopMn.Equals(CheckedMn);
            RightBottomMn.IsChecked = RightBottomMn.Equals(CheckedMn);
            FreedomMn.IsChecked = FreedomMn.Equals(CheckedMn);

            tbLeftTopMn.IsChecked = LeftTopMn.IsChecked;
            tbLeftBottomMn.IsChecked = LeftBottomMn.IsChecked;
            tbRightTopMn.IsChecked = RightTopMn.IsChecked;
            tbRightBottomMn.IsChecked = RightBottomMn.IsChecked;
            tbFreedomMn.IsChecked = FreedomMn.IsChecked;
        }
        private PositionType PosType
        {
            get { return this._PosType; }
            set
            {
                if (this._PosType != value)
                {
                    this._PosType = value;
                    FormUtils.AdjustWindowPos(this, PosType, IgnoreTaskBar);
                    switch (PosType)
                    {
                        case PositionType.LeftTop:
                            PosMnChecked(LeftTopMn);
                            break;
                        case PositionType.LeftBottom:
                            PosMnChecked(LeftBottomMn);
                            break;
                        case PositionType.RightTop:
                            PosMnChecked(RightTopMn);
                            break;
                        case PositionType.RightBottom:
                            PosMnChecked(RightBottomMn);
                            break;
                        case PositionType.Any:
                            PosMnChecked(FreedomMn);
                            break;
                    }
                    AyaClockConfig.Instance.PosType = this._PosType;
                    if (PosType == PositionType.Any)
                    {
                        AyaClockConfig.Instance.Left = (int)Left;
                        AyaClockConfig.Instance.Top = (int)Top;
                    }
                    SafetySaveConfig();
                }
            }
        }

        private MemUnitType MemUnit
        {
            get
            {
                if (KByteMn.IsChecked)
                    return MemUnitType.KByte;
                else if (MByteMn.IsChecked)
                    return MemUnitType.MByte;
                else
                    return MemUnitType.GByte;
            }
            set
            {
                if (value != this.MemUnit)
                {
                    switch (value)
                    {
                        case MemUnitType.KByte:
                            KByteMn.IsChecked = true;
                            MByteMn.IsChecked = false;
                            GByteMn.IsChecked = false;
                            //
                            tbKByteMn.IsChecked = true;
                            tbMByteMn.IsChecked = false;
                            tbGByteMn.IsChecked = false;
                            break;
                        case MemUnitType.MByte:
                            KByteMn.IsChecked = false;
                            MByteMn.IsChecked = true;
                            GByteMn.IsChecked = false;
                            //
                            tbKByteMn.IsChecked = false;
                            tbMByteMn.IsChecked = true;
                            tbGByteMn.IsChecked = false;
                            break;
                        case MemUnitType.GByte:
                            KByteMn.IsChecked = false;
                            MByteMn.IsChecked = false;
                            GByteMn.IsChecked = true;
                            //
                            tbKByteMn.IsChecked = false;
                            tbMByteMn.IsChecked = false;
                            tbGByteMn.IsChecked = true;
                            break;
                    }
                    AyaClockConfig.Instance.MemUnit = value;
                    SafetySaveConfig();
                }
            }
        }

        private bool ShowComma
        {
            get { return CommaMn.IsChecked; }
            set
            {
                if (value != this.ShowComma)
                {
                    CommaMn.IsChecked = value;
                    tbCommaMn.IsChecked = value;
                    AyaClockConfig.Instance.ShowComma = value;
                    SafetySaveConfig();
                }
            }
        }

        private void SetWeekdayMn(MenuItem ChkMn)
        {
            WeekDayNoneMn.IsChecked = WeekDayNoneMn.Equals(ChkMn);
            En2ChMn.IsChecked = En2ChMn.Equals(ChkMn);
            En3ChMn.IsChecked = En3ChMn.Equals(ChkMn);
            KanjiMn.IsChecked = KanjiMn.Equals(ChkMn);
            OsWeekdayMn.IsChecked = OsWeekdayMn.Equals(ChkMn);
            //
            tbWeekDayNoneMn.IsChecked = WeekDayNoneMn.IsChecked;
            tbEn2ChMn.IsChecked = En2ChMn.IsChecked;
            tbEn3ChMn.IsChecked = En3ChMn.IsChecked;
            tbKanjiMn.IsChecked = KanjiMn.IsChecked;
            tbOsWeekdayMn.IsChecked = OsWeekdayMn.IsChecked;
        }
        private WeekdayType Weekday
        {
            get
            {
                if (En2ChMn.IsChecked)
                    return WeekdayType.Eng2ch;
                if (En3ChMn.IsChecked)
                    return WeekdayType.Eng3ch;
                if (KanjiMn.IsChecked)
                    return WeekdayType.Kanji;
                if (OsWeekdayMn.IsChecked)
                    return WeekdayType.OsSetting;
                return WeekdayType.None;
            }
            set
            {
                if (value != this.Weekday)
                {
                    switch (value)
                    {
                        case WeekdayType.None:
                            SetWeekdayMn(WeekDayNoneMn);
                            break;
                        case WeekdayType.Eng2ch:
                            SetWeekdayMn(En2ChMn);
                            break;
                        case WeekdayType.Eng3ch:
                            SetWeekdayMn(En3ChMn);
                            break;
                        case WeekdayType.Kanji:
                            SetWeekdayMn(KanjiMn);
                            break;
                        case WeekdayType.OsSetting:
                            SetWeekdayMn(OsWeekdayMn);
                            break;
                    }
                    AyaClockConfig.Instance.Weekday = value;
                    SafetySaveConfig();
                }
            }
        }

        private bool ShowSecond
        {
            get { return SecondMn.IsChecked; }
            set
            {
                if (value != this.ShowSecond)
                {
                    SecondMn.IsChecked = value;
                    tbSecondMn.IsChecked = value;
                    AyaClockConfig.Instance.ShowSecond = value;
                    SafetySaveConfig();
                }
            }
        }

        private bool ShowTasktrayIcon
        {
            get { return ni.Visibility==Visibility.Visible; }
            set
            {
                if (value != this.ShowTasktrayIcon)
                {
                    TasktrayMn.IsChecked = value;
                    tbTasktrayMn.IsChecked = value;
                    if (value)
                        ni.Visibility = Visibility.Visible;
                    else
                        ni.Visibility = Visibility.Collapsed;
                    AyaClockConfig.Instance.ShowTasktrayIcon = value;
                    SafetySaveConfig();
                }
            }
        }

        private ColorType ColorType
        {
            get
            {
                if (ThemeColorMn.IsChecked || tbThemeColorMn.IsChecked)
                    return ColorType.Theme;
                else
                    return ColorType.Default;
            }
            set
            {
                if (value != ColorType)
                {
                    if (value == ColorType.Theme)
                    {
                        DefaultColorMn.IsChecked = false;
                        ThemeColorMn.IsChecked = true;
                        //
                        tbDefaultColorMn.IsChecked = false;
                        tbThemeColorMn.IsChecked = true;
                    }
                    else
                    {
                        DefaultColorMn.IsChecked = true;
                        ThemeColorMn.IsChecked = false;
                        //
                        tbDefaultColorMn.IsChecked = true;
                        tbThemeColorMn.IsChecked = false;
                    }
                    AyaClockConfig.Instance.Color = value;
                    SafetySaveConfig();
                    ChangeTheme();
                }
            }
        }

        /// <summary>
        ///  内部処理用プロパティなどなど
        /// </summary>

        private string MemUnitStr
        {
            get
            {
                switch (MemUnit)
                {
                    case MemUnitType.KByte:
                        return "KB";
                    case MemUnitType.MByte:
                        return "MB";
                    case MemUnitType.GByte:
                        return "GB";
                    default:
                        return "MB";
                }
            }
        }

        private static string[,] WeekdayStrs = { /* none */  { "","","","","","","" },
                                                 /* Eng3 */  { "(Sun)","(Mon)","(Tue)","(Wed)","(Thu)","(Fri)","(Sat)" },
                                                 /* Eng2 */  { "(Su)","(Mo)","(Tu)","(We)","(Th)","(Fr)","(Sa)" },
                                                 /* Kanji */ { "(日)","(月)","(火)","(水)","(木)","(金)","(土)" },
                                                 /* OS */    { "","","","","","","" } };
        private string WeekdayStr
        {
            get { return WeekdayStrs[(int)Weekday, int.Parse(DateTime.Now.DayOfWeek.ToString("d"))]; }
        }

        private UInt64 MemModifier
        {
            get
            {
                switch (MemUnit)
                {
                    case MemUnitType.KByte:
                        return 1024;
                    case MemUnitType.MByte:
                        return 1024 * 1024;
                    case MemUnitType.GByte:
                        return 1024 * 1024 * 1024;
                    default:
                        return 1024 * 1024;
                }
            }
        }

        private System.Globalization.NumberFormatInfo nfi = null;
        private string ToCommaStr(UInt64 AValue)
        {
            if (nfi == null)
            {
                nfi = (System.Globalization.NumberFormatInfo)System.Globalization.NumberFormatInfo.CurrentInfo.Clone();
                nfi.NumberDecimalDigits = 0;
            }
            return AValue.ToString("N", nfi);
        }

        /// <summary>
        /// 日付・時間・空きメモリのupdate
        /// </summary>

        private int tPassed = -1;

        private void SetOsWeekdayStrs(DateTime N)
        {
            // 曜日文字列設定 - 短い曜日文字列
            int cnt = 0;
            while (cnt < 7)
            {
                WeekdayStrs[4, cnt] = "(" + System.Globalization.DateTimeFormatInfo.CurrentInfo.ShortestDayNames[cnt] + ")";
                cnt++;
            }
        }

        private void UpdateTimeAndMem()
        {
            // 最初に時間を保存
            DateTime N = DateTime.Now;

            // 日付
            string MDfmt = DateTimeFormatInfo.CurrentInfo.ShortDatePattern.ToUpper(); // 短い日付フォーマット
            string MDsep = DateTimeFormatInfo.CurrentInfo.DateSeparator;
            string work = "";

            int Mpos = MDfmt.IndexOf('M');
            int Dpos = MDfmt.IndexOf('D');

            if (Mpos == -1 || Dpos == -1 || Mpos < Dpos)
                // 月/日の場合 or なんかエラーだった場合
                work = string.Format("{0:00}" + MDsep + "{1:00}",
                                     int.Parse(N.Month.ToString()),
                                     int.Parse(N.Day.ToString()));
            else
                // 日/月の場合
                work = string.Format("{0:00}" + MDsep + "{1:00}",
                                     int.Parse(N.Day.ToString()),
                                     int.Parse(N.Month.ToString()));
            // 曜日
            DateLB.Content = work + WeekdayStr;

            // 時間
            if (ShowSecond)
                TimeLB.Content = N.TimeOfDay.ToString().Substring(0, 8);
            else
                TimeLB.Content = N.TimeOfDay.ToString().Substring(0, 5);

            // 空きメモリ
            UInt64 m = 0;
            MEMORYSTATUSEX memsts = new MEMORYSTATUSEX();
            memsts.dwLength = (UInt32)System.Runtime.InteropServices.Marshal.SizeOf(memsts);
            if (GlobalMemoryStatusEx(ref memsts))
                m = memsts.ullAvailPhys / MemModifier;
            if (ShowComma)
                MemLB.Content = ToCommaStr(m) + MemUnitStr;
            else
                MemLB.Content = m.ToString() + MemUnitStr;

            // 更新「分秒」保存
            tPassed = N.Minute * 100 + N.Second;
        }

        // ウインドウ移動用ワーク
        private Point sv_pt;
        private Point sv_cursor_pt;

        public MainWindow()
        {
            InitializeComponent();
            InitDatas();
        }

        // 各種初期化処理
        private void FontSettingForLabel(ref Label ALabel)
        {
            ALabel.FontFamily = label1.FontFamily;
            ALabel.FontSize = label1.FontSize;
            ALabel.FontWeight = label1.FontWeight;
            ALabel.FontStyle = label1.FontStyle;
        }

        private void FontSettingForLabels()
        {
            FontSettingForLabel(ref DateLB);
            FontSettingForLabel(ref TimeLB);
            FontSettingForLabel(ref MemLB);
        }

        private void SetSmallShieldIcon()
        {
            // AdjustTime Menuにシールドアイコンを設定
            StockIcon icon = new StockIcon();
            icon.Identifier = StockIconIdentifier.Shield;
            icon.Small = true;
            //
            Image image = new Image();
            image.Source = icon.Bitmap;
            image.Stretch = Stretch.None;
            AdjustTimeMn.Icon = image;
            ///
            Image image2 = new Image();
            image2.Source = icon.Bitmap;
            image2.Stretch = Stretch.None;
            tbAdjustTimeMn.Icon = image2;
        }

        private static bool dragging_now;
        private DispatcherTimer timer;

        private void InitDatas()
        {
            dragging_now = false;
            LeftTopMn.IsChecked = true;
            tbLeftTopMn.IsChecked = true;
            // shield iconの設定
            SetSmallShieldIcon();
            // 曜日文字列の初期設定
            SetOsWeekdayStrs(DateTime.Now);
            // configure data読み込み
            AyaClockConfig.LoadConfig();
            // Tasktray Icon表示の有無
            ShowTasktrayIcon = AyaClockConfig.Instance.ShowTasktrayIcon;
            // メモリ表示
            MByteMn.IsChecked = true;
            tbMByteMn.IsChecked = true;
            MemUnit = AyaClockConfig.Instance.MemUnit;
            ShowComma = AyaClockConfig.Instance.ShowComma;
            // 曜日表示
            WeekDayNoneMn.IsChecked = true;
            tbWeekDayNoneMn.IsChecked = true;
            Weekday = AyaClockConfig.Instance.Weekday;
            // 秒表示
            SecondMn.IsChecked = false;
            tbSecondMn.IsChecked = false;
            ShowSecond = AyaClockConfig.Instance.ShowSecond;
            // DPI確定のため、位置だけ先に確定
            Left = AyaClockConfig.Instance.Left;
            Top = AyaClockConfig.Instance.Top;
            // フォント
            try
            {
                label1.FontFamily = new System.Windows.Media.FontFamily(AyaClockConfig.Instance.FontFamily);
            }
            catch
            {
                label1.FontFamily = new System.Windows.Media.FontFamily(AyaClockConfig.DefaultFontfamily);
            }
            label1.FontSize = AyaClockConfig.Instance.FontSize;
            FontStyleConverter fsc1 = new FontStyleConverter();
            try
            {
                label1.FontStyle = (FontStyle)fsc1.ConvertFromString(AyaClockConfig.Instance.FontStyle);
            }
            catch
            {
                label1.FontStyle = (FontStyle)fsc1.ConvertFromString(AyaClockConfig.DefaultFontstyle);
            }
            FontWeightConverter fwc = new FontWeightConverter();
            try
            {
                label1.FontWeight = (System.Windows.FontWeight)fwc.ConvertFromString(AyaClockConfig.Instance.FontWeight);
            }
            catch
            {
                label1.FontWeight = (System.Windows.FontWeight)fwc.ConvertFromString(AyaClockConfig.DefaultFontweight);
            }
            FontStretchConverter fsc2 = new FontStretchConverter();
            try
            {
                label1.FontStretch = (FontStretch)fsc2.ConvertFromString(AyaClockConfig.Instance.FontStretch);
            }
            catch
            {
                label1.FontStretch = (FontStretch)fsc2.ConvertFromString(AyaClockConfig.DefaultFontstretch);
            }
            FontSettingForLabels();
            // 設定条件からwindow size決定
            CalcSize();
            // 表示文字列の設定
            UpdateTimeAndMem();
            // 位置の復帰 - 先に位置を復帰しないとDPIが確定しない
            IgnoreTaskBar = AyaClockConfig.Instance.IgnoreTaskBar;
            StayOnTop = AyaClockConfig.Instance.StayOnTop;
            if (AyaClockConfig.Instance.PosType == PositionType.Any)
            {
                Left = AyaClockConfig.Instance.Left;
                Top = AyaClockConfig.Instance.Top;
            }
            PosType = AyaClockConfig.Instance.PosType; // 位置情報の後で復帰する - 位置調整のため
            // Theme設定
            ColorType = AyaClockConfig.Instance.Color;
            ChangeTheme();
            // Timer Start
            timer = new DispatcherTimer();
            timer.Tick += new EventHandler(OnTimer);
            timer.Interval = new TimeSpan(0, 0, 0, 0, 200);
            timer.Start();
        }

        int SecondCounter = 0; // 1分経過したかどうかのカウンタ
        const int OneMinute = 60; // 1分の秒数

        // Timer処理
        private void OnTimer(object sender, EventArgs e)
        {
            // logoff or shutdown中
            if (SystemShutdownFlag) return;

            // まだ準備ができていない
            if (!label1.IsInitialized) return;

            // 分秒が変わっている？
            DateTime N = DateTime.Now;
            int sv = N.Minute * 100 + N.Second;
            bool TimeChanged = (tPassed != sv);

            // ver 0.12の追加処理 - .NET runtime library updateに関連する不具合対策
            if (TimeChanged)
            {
                SecondCounter++;
                if (SecondCounter >= OneMinute)
                {
                    // 1分以上経過したのでカウンターリセット
                    SecondCounter = 0;
                    // 更にruntime libraryのバージョンを確認
                    if (UpdateChecker.IsExistsNewerVerRuntime() != UpdateChecker.resultType.None)
                    {
                        // runtimeがupdateされていたのでtimerを停止して
                        timer.Stop();
                        // ユーザーにruntime updateが有ったことを通知
                        var ToastWin = new ToastWin();
                        ToastWin.Owner = this;
                        ToastWin.SetCloseTimer(7); // 7秒で自動的に閉じる
                        ToastWin.ShowDialog();
                        // AyaClock.NETを終了
                        Close();
                        return; // ここで終了
                    }
                }
            }

            // 移動中は処理停止
            if (label1.IsMouseCaptured) return;
            if (dragging_now) return;


            // 「分秒」が変わった？
            if (TimeChanged)
            {
                // 変わっていたので更新
                UpdateTimeAndMem();
            }

            // 必要があれば位置調整
            double sv_l = Left, sv_t = Top;
            FormUtils.AdjustWindowPos(this, PosType, IgnoreTaskBar);
            if (sv_l != Left || sv_t != Top)
            {
                // 位置が変更されたので保存しておく
                SavePosition();
            }
        }

        // AyaClock.NETの終了
        private void QuitMn_Click(object sender, RoutedEventArgs e)
        {
            Close();
        }

        // label1からFormattedText生成
        private FormattedText MakeFT(string AText)
        {
            FormattedText result = new FormattedText(AText,
                                                     System.Globalization.CultureInfo.CurrentCulture,
                                                     FlowDirection.LeftToRight,
                                                     new Typeface(label1.FontFamily,
                                                                  label1.FontStyle,
                                                                  label1.FontWeight,
                                                                  label1.FontStretch),
                                                                  label1.FontSize,
                                                                  Brushes.Black,
                                                                  1.0  /* VisualTreeHelper.GetDpi(this).PixelsPerDip */); // DPIは96.0前提で計算！

            result.SetFontFamily(label1.FontFamily);
            result.SetFontStyle(label1.FontStyle);
            result.SetFontWeight(label1.FontWeight);
            result.SetFontStretch(label1.FontStretch);
            result.SetFontSize(label1.FontSize);
            return result;
        }

        // 各種設定からWindow Size決定
        private void CalcSize()
        {
            // 数字の中で一番幅の大きい文字を取得
            FormattedText ft = MakeFT("0");
            double numWidth = ft.Width, maxH = ft.Height;
            char max_c = '0';
            for (char c = '1'; c <= '9'; c++)
            {
                ft = MakeFT("" + c);
                if (ft.Width > numWidth)
                {
                    max_c = c; numWidth = ft.Width;
                }
                if (ft.Height > maxH)
                {
                    maxH = ft.Height;
                }
            }

            // ラベル間のスペースを決定 : 一番幅の大きい数字の1/2
            double spWidth = numWidth / 2;

            // 日付ラベルの幅を決定
            string dateStr = "" + max_c + max_c + DateTimeFormatInfo.CurrentInfo.DateSeparator + max_c + max_c;
            string wdStr = WeekdayStrs[(int)Weekday, 0];
            ft = MakeFT(wdStr);
            double wdWidth = ft.Width;
            if (ft.Height > maxH)
            {
                maxH = ft.Height;
            }
            for (int i = 1; i < 7; i++)
            {
                ft = MakeFT(WeekdayStrs[(int)Weekday, i]);
                if (ft.Width > wdWidth)
                {
                    wdStr = WeekdayStrs[(int)Weekday, i];
                    wdWidth = ft.Width;
                }
                if (ft.Height > maxH)
                {
                    maxH = ft.Height;
                }
            }
            ft = MakeFT(dateStr + wdStr);
            wdWidth = ft.Width + 2 * DateLB.Padding.Left;
            if (ft.Height > maxH)
            {
                maxH = ft.Height;
            }

            // 時間ラベルの幅を決定
            string timeStr = "" + max_c + max_c + DateTimeFormatInfo.CurrentInfo.TimeSeparator + max_c + max_c;
            if (ShowSecond)
                timeStr = timeStr + DateTimeFormatInfo.CurrentInfo.TimeSeparator + max_c + max_c;
            ft = MakeFT(timeStr);
            double tmWidth = ft.Width + 2 * TimeLB.Padding.Left;
            if (ft.Height > maxH)
            {
                maxH = ft.Height;
            }

            // メモリラベルの幅を決定
            MEMORYSTATUSEX memsts = new MEMORYSTATUSEX();
            UInt64 m = 0, max_m = 0;
            memsts.dwLength = (UInt32)System.Runtime.InteropServices.Marshal.SizeOf(memsts);
            if (GlobalMemoryStatusEx(ref memsts))
            {
                m = memsts.ullAvailPhys / MemModifier;
                max_m = memsts.ullTotalPhys / MemModifier;
            }
            UInt64 MaxLen = (UInt64)max_m.ToString().Length; // 搭載メモリの最大長
            UInt64 MaxLenNum = 0;
            for (UInt64 i = 0; i < MaxLen; i++)
            {
                // 仮の数字 1 で最大桁数の数字を作成しておく
                MaxLenNum = MaxLenNum * 10 + 1;
            }
            string memStr = "";
            if (ShowComma)
                memStr = ToCommaStr(MaxLenNum);
            else
                memStr = MaxLenNum.ToString();
            memStr.Replace('1', max_c); // 1 を 最大幅の文字で置き換える
            memStr += MemUnitStr;
            ft = MakeFT(memStr);
            double memWidth = ft.Width + 2 * MemLB.Padding.Left;
            if (ft.Height > maxH)
            {
                maxH = ft.Height;
            }

            // Window Size決定
            Height = 3 * 2 + maxH + 2 * 2;
            Width = 3 * 2 + wdWidth + spWidth + tmWidth + spWidth + memWidth;

            // Inner Grid Size 決定
            LbGrid.ColumnDefinitions[0].MaxWidth = LbGrid.ColumnDefinitions[0].MinWidth = wdWidth;
            LbGrid.ColumnDefinitions[1].MaxWidth = LbGrid.ColumnDefinitions[1].MinWidth = spWidth;
            LbGrid.ColumnDefinitions[2].MaxWidth = LbGrid.ColumnDefinitions[2].MinWidth = tmWidth;
            LbGrid.ColumnDefinitions[3].MaxWidth = LbGrid.ColumnDefinitions[3].MinWidth = spWidth;
            LbGrid.ColumnDefinitions[4].MaxWidth = LbGrid.ColumnDefinitions[4].MinWidth = memWidth;
        }

        // Size決定＆位置調整
        private void CalcSizeAndPos()
        {
            if (!SystemShutdownFlag) // OS Shutdown時のメモリアクセス違反をガード用に、念のためガードをかけておく
            { 
                CalcSize();
                UpdateTimeAndMem();
                double sv_l = Left, sv_t = Top;
                FormUtils.AdjustWindowPos(this, PosType, IgnoreTaskBar);
                if (sv_l != Left || sv_t != Top)
                {
                    SavePosition();
                }
            }
        }

        // Aboutの表示
        private void AboutMn_Click(object sender, RoutedEventArgs e)
        {
            AboutF fm = new AboutF();
            fm.Owner = this;
            fm.ShowDialog();
        }

        // マウスによる移動処理(PositionTypeがAnyの時のみ)
        private void label1_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            if (PosType != PositionType.Any) return;
            // postion typeがanyの時に限り移動可能
            if (label1.CaptureMouse())
            {
                sv_pt = new Point(Left, Top);
                sv_cursor_pt = e.GetPosition(this);
                sv_cursor_pt.X += sv_pt.X;
                sv_cursor_pt.Y += sv_pt.Y;
                Cursor = Cursors.Hand;
                dragging_now = true;
            }
        }

        private void label1_MouseMove(object sender, MouseEventArgs e)
        {
            if (label1.IsMouseCaptured && dragging_now)
            {
                Point now_pt = e.GetPosition(this);
                now_pt.X += Left;
                now_pt.Y += Top;
                Left += now_pt.X - sv_cursor_pt.X;
                Top += now_pt.Y - sv_cursor_pt.Y;
                sv_pt = new Point(Left, Top);
                sv_cursor_pt = now_pt;
            }
        }

        private void SavePosition()
        {
            AyaClockConfig.Instance.Left = (int)Left;
            AyaClockConfig.Instance.Top = (int)Top;
            SafetySaveConfig();
        }

        private void label1_MouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            if (label1.IsMouseCaptured && dragging_now)
            {
                label1.ReleaseMouseCapture();
                Cursor = Cursors.Arrow;
                SavePosition();
                dragging_now = false;
            }
        }

        // PositionTypeの設定
        private void PosTypeMn_Click(object sender, RoutedEventArgs e)
        {
            if (LeftTopMn.Equals(sender) || tbLeftTopMn.Equals(sender))
            {
                PosType = PositionType.LeftTop;
            }
            else if (LeftBottomMn.Equals(sender) || tbLeftBottomMn.Equals(sender))
            {
                PosType = PositionType.LeftBottom;
            }
            else if (RightTopMn.Equals(sender) || tbRightTopMn.Equals(sender))
            {
                PosType = PositionType.RightTop;
            }
            else if (RightBottomMn.Equals(sender) || tbRightBottomMn.Equals(sender))
            {
                PosType = PositionType.RightBottom;
            }
            else if (FreedomMn.Equals(sender) || tbFreedomMn.Equals(sender))
            {
                PosType = PositionType.Any;
            }
        }

        // StayOnTopの設定
        private void StayOnTopMn_Click(object sender, RoutedEventArgs e)
        {
            StayOnTopMn.IsChecked = !StayOnTopMn.IsChecked;
            tbStayOnTopMn.IsChecked = StayOnTopMn.IsChecked;
            StayOnTop = StayOnTopMn.IsChecked;
        }

        // TaskBarを無視するかどうかの設定
        private void IgnoreTaskBarMn_Click(object sender, RoutedEventArgs e)
        {
            IgnoreTaskBarMn.IsChecked = !IgnoreTaskBarMn.IsChecked;
            tbIgnoreTaskBarMn.IsChecked = IgnoreTaskBarMn.IsChecked;
            IgnoreTaskBar = IgnoreTaskBarMn.IsChecked;
        }

        private void WpfFontDialog()
        {
            var dlg = new emanual.Wpf.Dialogs.FontDialogEx();
            dlg.Left = this.Left + 50;
            dlg.Top = this.Top + 50;

            var font = new emanual.Wpf.Dialogs.ToolFont();
            font.FontFamily = label1.FontFamily;
            font.FontSize = label1.FontSize;
            font.FontWeight = label1.FontWeight;
            font.FontStyle = label1.FontStyle;
            font.FontStretch = label1.FontStretch;

            font.FontLanguage = ""; // 全言語

            dlg.Font = font;
            dlg.SampleText = "AaBbYyZz\r\nＡａあぁアァ亜宇";

            if (dlg.ShowDialog().Value)
            {
                dlg.SetPropertyToTargetObject(label1);
                AyaClockConfig.Instance.FontFamily = label1.FontFamily.ToString();
                AyaClockConfig.Instance.FontSize = label1.FontSize;
                AyaClockConfig.Instance.FontWeight = label1.FontWeight.ToString();
                AyaClockConfig.Instance.FontStyle = label1.FontStyle.ToString();
                AyaClockConfig.Instance.FontStretch = label1.FontStretch.ToString();

                // 設定
                FontSettingForLabels();
                // 調整
                CalcSizeAndPos();
                // 保存
                SafetySaveConfig();
            }
        }

        private void FontMn_Click(object sender, RoutedEventArgs e)
        {
            WpfFontDialog();
        }

        // コントロールパネルを開く
        private void AdjustTimeMn_Click(object sender, RoutedEventArgs e)
        {
            System.Diagnostics.Process proc = new System.Diagnostics.Process();
            proc.StartInfo.FileName = "rundll32.exe";
            proc.StartInfo.Arguments = "shell32.dll,Control_RunDLL Timedate.cpl";
            proc.StartInfo.UseShellExecute = true;
            proc.StartInfo.Verb = "open";
            proc.Start();
        }

        // メモリ表示量の単位設定
        private void MemUnitMn_Click(object sender, RoutedEventArgs e)
        {
            if (KByteMn.Equals(sender) || tbKByteMn.Equals(sender))
            {
                MemUnit = MemUnitType.KByte;
            }
            else if (MByteMn.Equals(sender) || tbMByteMn.Equals(sender))
            {
                MemUnit = MemUnitType.MByte;
            }
            else if (GByteMn.Equals(sender) || tbGByteMn.Equals(sender))
            {
                MemUnit = MemUnitType.GByte;
            }
            CalcSizeAndPos();
        }

        // メモリの区切り表示の有無
        private void CommaMn_Click(object sender, RoutedEventArgs e)
        {
            ShowComma = !ShowComma;
            CalcSizeAndPos();
        }

        // 曜日表示の設定
        private void WeekdayMn_Click(object sender, RoutedEventArgs e)
        {
            if (WeekDayNoneMn.Equals(sender) || tbWeekDayNoneMn.Equals(sender))
                Weekday = WeekdayType.None;
            else if (En2ChMn.Equals(sender) || tbEn2ChMn.Equals(sender))
                Weekday = WeekdayType.Eng2ch;
            else if (En3ChMn.Equals(sender) || tbEn3ChMn.Equals(sender))
                Weekday = WeekdayType.Eng3ch;
            else if (KanjiMn.Equals(sender) || tbKanjiMn.Equals(sender))
                Weekday = WeekdayType.Kanji;
            else if (OsWeekdayMn.Equals(sender) || tbOsWeekdayMn.Equals(sender))
                Weekday = WeekdayType.OsSetting;
            CalcSizeAndPos();
        }

        // 「秒」の表示の有無
        private void SecondMn_Click(object sender, RoutedEventArgs e)
        {
            ShowSecond = !ShowSecond;
            CalcSizeAndPos();
        }

        // TasktrayIcon表示の有無
        private void TasktrayMn_Click(object sender, RoutedEventArgs e)
        {
            ShowTasktrayIcon = !ShowTasktrayIcon;
        }

        // Default Colorで描画
        private void DefaultColorMn_Click(object sender, RoutedEventArgs e)
        {
            ColorType = ColorType.Default;
        }

        // Theme Colorで描画
        private void ThemeColorMn_Click(object sender, RoutedEventArgs e)
        {
            ColorType = ColorType.Theme;
        }

        // WM_SETTINGCHANGE処理
        private const int WM_SETTINGCHANGE = 0x001A;

        private static bool IsWindowsDarkMode()
        {
            using var key = Registry.CurrentUser.OpenSubKey(@"Software\Microsoft\Windows\CurrentVersion\Themes\Personalize");
            var value = key?.GetValue("AppsUseLightTheme");
            return value is int i && i == 0;
        }

        // windowを(従来の)Buttonぽく見せる為の処理
        private void ShowFakeButton(bool bShow)
        {
            rectangleC.Opacity = bShow ? 1 : 0;
            rectangleL.Opacity = bShow ? 1 : 0;
            rectangleLB.Opacity = bShow ? 1 : 0;
            rectangleLT.Opacity = bShow ? 1 : 0;
            rectangleR.Opacity = bShow ? 1 : 0;
            rectangleRB.Opacity = bShow ? 1 : 0;
            rectangleRT.Opacity = bShow ? 1 : 0;
        }

        // Theme変更処理
        private void ChangeTheme()
        {
            var theme = Application.Current.Resources.MergedDictionaries[0] as DynamicAero2.Theme;

            switch (ColorType)
            {
                case ColorType.Default:
                    // change to default theme
                    if (theme is not null) theme.Color = DynamicAero2.ThemeColor.NormalColor;
                    ShowFakeButton(true);
                    break;
                case ColorType.Theme:
                    // change to light/dark theme
                    if (IsWindowsDarkMode())
                    {
                        // dark theme
                        if (theme is not null) theme.Color = DynamicAero2.ThemeColor.Dark;
                        ShowFakeButton(false);
                    }
                    else
                    {
                        // light theme
                        if (theme is not null) theme.Color = DynamicAero2.ThemeColor.Light;
                        ShowFakeButton(false);
                    };
                    break;
            }
        }

        // WM_QUERYENDSESSION処理用
        private const int WM_QUERYENDSESSION = 0x11;
        private const int WM_ENDSESSION = 0x16;
        private const uint ENDSESSION_LOGOFF = 0x80000000;
        private bool SystemShutdownFlag = false;

        // 特定のメッセージ処理用hook func
        private IntPtr WndProc(IntPtr hwnd, int msg, IntPtr wParam, IntPtr lParam, ref bool handled)
        {
            // 返却初期値
            IntPtr result = IntPtr.Zero;

            // WM_SETTINGCHANGE処理
            if (msg == WM_SETTINGCHANGE)
            {
                var prm = Marshal.PtrToStringAuto(lParam);
                if (prm == "ImmersiveColorSet")
                {
                    // Themeの変更処理
                    ChangeTheme();
                    handled = true;
                }
                else
                    handled = false;
            }
            // shutdown or logoff要求されたときの処理
            else if (msg == WM_QUERYENDSESSION)
            {
                timer.Stop();              // Timerを止めて
                //SavePosition();            // 位置保存して → 中止 ver 0.12
                SystemShutdownFlag = true; // logoff or shutdown中フラグを立てておく
                handled = false;           // DefWindowProcに流して true を返すようにしておく
            }
            // 
            else if (msg == WM_ENDSESSION)
            {
                if (!SystemShutdownFlag)
                {
                    //SavePosition(); // しない方がよいかも？
                    timer.Stop();     
                    SystemShutdownFlag = true;
                }
                handled = false;
            }
            else
                handled = false;  
            return result;
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            // 特定のメッセージをフックして処理するために追加
            HwndSource source = HwndSource.FromHwnd(new WindowInteropHelper(this).Handle);
            source.AddHook(new HwndSourceHook(WndProc));

            // Theme Colorの準備
            var theme = Application.Current.Resources.MergedDictionaries[0] as DynamicAero2.Theme;
            if (theme != null)
                theme.Color = DynamicAero2.ThemeColor.NormalColor;
            ShowFakeButton(true);
        }

        private void Window_Closed(object sender, EventArgs e)
        {
            timer.Stop(); // timerは停止しておく
        }
    }
}
