﻿using Ayakawa.FormUtils;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Threading;

namespace AyaClock.WPF
{
    /// <summary>
    /// ToastWin.xaml の相互作用ロジック
    /// </summary>
    public partial class ToastWin : Window
    {
        private bool FirstActivated;
        private DispatcherTimer timer;
        private int ACloseTime = 10;

        public ToastWin()
        {
            InitializeComponent();
            FirstActivated = true;
        }

        public void SetCloseTimer(int asec)
        {
            if (asec>0) ACloseTime = asec;
        }

        private void button1_Click(object sender, RoutedEventArgs e)
        {
            Close();
        }

        private void Window_Activated(object sender, EventArgs e)
        {
            if (FirstActivated)
            {
                FirstActivated = false;
                // 位置調整
                if (Owner!=null) FormUtils.AdjustWindowPos(this, PositionType.Any, false);
                // Timer Start
                timer = new DispatcherTimer();
                timer.Tick += new EventHandler(OnTimer);
                timer.Interval = new TimeSpan(0, 0, 0, ACloseTime, 0);
                timer.Start();
            }
        }

        private void OnTimer(object sender, EventArgs e)
        {
            timer.Stop();
            Close();
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
#if DEBUG
            Title = "AyaClock.Wpf Info (DEBUG MODE)";
#endif
        }
    }
}
