﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Media;
using Ayakawa.FormUtils;
using Microsoft.VisualBasic;

namespace AyaClock.WPF
{
    public enum MemUnitType
    {
        KByte = 0,
        MByte,
        GByte
    }

    public enum WeekdayType
    {
        None = 0,
        Eng3ch,
        Eng2ch,
        Kanji,
        OsSetting
    }

    public enum ColorType
    {
        Default = 0,
        Theme 
    }


    [Serializable()]
    public class AyaClockConfig
    {
        // classはpublicにしておかないとシリアライズの時点でエラーが発生する

        // config dataを保存するファイル名
        private const string ConfigFilename = "config.wpf.data";

        // default values
        public const string DefaultFontfamily = "メイリオ";
        public const double DefaultFontsize = 15;
        public const string DefaultFontweight = "Normal";
        public const string DefaultFontstyle = "Normal";
        public const string DefaultFontstretch = "Normal";
        public const ColorType DefaultColor = ColorType.Default;

        /// <summary>
        /// 位置情報
        /// </summary>
        private int _Left, _Top;
        private PositionType _PosType;
        private bool _StayOnTop,_IgnoreTaskBar;
        /// <summary>
        /// フォント情報
        /// </summary>
        private string _FontFamily;
        private double _Size;
        private string _Weight;
        private string _Style;
        private string _Stretch;
        /// <summary>
        /// Theme Color
        /// </summary>
        private ColorType _color;
        /// <summary>
        /// メモリ表示
        /// </summary>
        private MemUnitType _MemUnit;
        private bool _ShowComma;
        /// <summary>
        /// 曜日表示
        /// </summary>
        private WeekdayType _Weekday;
        /// <summary>
        /// 秒表示
        /// </summary>
        private bool _ShowSecond;
        /// <summary>
        /// タスクトレイアイコン表示の有無
        /// </summary>
        private bool _ShowTasktrayIcon;

        public int Left
        {
            get { return _Left; }
            set { _Left = value; }
        }
        public int Top
        {
            get { return _Top; }
            set { _Top = value; }
        }
        public PositionType PosType
        {
            get { return _PosType; }
            set { _PosType = value; }
        }
        public bool StayOnTop
        {
            get { return _StayOnTop; }
            set { _StayOnTop = value; }
        }
        public bool IgnoreTaskBar
        {
            get { return _IgnoreTaskBar; }
            set { _IgnoreTaskBar = value; }
        }
        public string FontFamily
        {
            get { return _FontFamily; }
            set { _FontFamily = value; }
        }
        public double FontSize
        {
            get { return _Size; }
            set { if (value>0) _Size = value; }
        }
        public string FontWeight
        {
            get { return _Weight; }
            set { _Weight = value; }
        }
        public string FontStyle
        {
            get { return _Style; }
            set { _Style = value; }
        }
        public string FontStretch
        {
            get { return _Stretch; }
            set { _Stretch = value; }
        }
        public ColorType Color
        {
            get { return _color; }
            set { _color = value; }
        }
        public MemUnitType MemUnit
        {
            get { return _MemUnit; }
            set { _MemUnit = value; }
        }
        public bool ShowComma
        {
            get { return _ShowComma; }
            set { _ShowComma = value; }
        }
        public WeekdayType Weekday
        {
            get { return _Weekday; }
            set { _Weekday = value; }
        }
        public bool ShowSecond
        {
            get { return _ShowSecond; }
            set { _ShowSecond = value; }
        }
        public bool ShowTasktrayIcon
        {
            get { return _ShowTasktrayIcon; }
            set { _ShowTasktrayIcon = value; }
        }

        // constructor
        public AyaClockConfig()
        {
            PosType = PositionType.LeftTop;
            Left = 0; Top = 0;
            StayOnTop = false;
            FontFamily = DefaultFontfamily;
            FontSize = DefaultFontsize;
            FontWeight = DefaultFontweight;
            FontStyle = DefaultFontstyle;
            FontStretch = DefaultFontstretch;
            Color = DefaultColor;
            MemUnit = MemUnitType.MByte;
            ShowComma = true;
            Weekday = WeekdayType.None;
            ShowSecond = false;
            _ShowTasktrayIcon = false;
        }

        // singleton instance
        [NonSerialized()]
        private static AyaClockConfig _instance;
        [System.Xml.Serialization.XmlIgnore]
        public static AyaClockConfig Instance
        {
            get
            {
                if (_instance == null)
                    _instance = new AyaClockConfig();
                return _instance;
            }
            set { _instance = value; }
        }

        // load config
        public static void LoadConfig()
        {
            string path = GetConfigPath();
            FileStream fs=null;
            try
            {
                fs = new FileStream(path, FileMode.Open, FileAccess.Read);
                System.Xml.Serialization.XmlSerializer xs = new System.Xml.Serialization.XmlSerializer(typeof(AyaClockConfig));
                object obj = xs.Deserialize(fs);
                _instance = (AyaClockConfig)obj;
            }
            catch (FileNotFoundException)
            {
                // config.dataが無いのでなにもせん!
                return;
            }
            catch (Exception ex)
            {
                // なんぞのエラーが発生 > とりあえず無視
                _ = MessageBox.Show(ex.Message, "load config");
            }
            finally
            {
                if (fs != null) fs.Close();
            }
        }

        // save config
        public static void SaveConfig()
        {
            string path = GetConfigPath();
            FileStream fs = null;
            try
            {
                fs = new FileStream(path,FileMode.Create,FileAccess.Write);
                System.Xml.Serialization.XmlSerializer xs = new System.Xml.Serialization.XmlSerializer(typeof(AyaClockConfig));
                xs.Serialize(fs, Instance);
            }
            catch (Exception ex)
            {
                // なんぞのエラーが発生
                _ = MessageBox.Show(ex.Message, "save config");
            }
            finally
            {
                if (fs != null) fs.Close();
            }
        }

        // helper routines
        public static string GetConfigPath()
        {
            // save folderが無い場合は構築しておかねばならない！
            string result = Path.Combine(Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData), // Roaming Folder
                                  "MarleySoft\\");
            if (!System.IO.Directory.Exists(result))
            {
                System.IO.Directory.CreateDirectory(result);
            }
            result = Path.Combine(result, "AyaClock.WPF\\");
            if (!System.IO.Directory.Exists(result))
            {
                System.IO.Directory.CreateDirectory(result);
            }
            //
            result = Path.Combine(result, ConfigFilename);
            return result;
        }
    }
}
