﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Runtime.InteropServices;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using Ayakawa.DotNetRuntimeUpdateCheker;

namespace AyaClock.WPF
{
    /// <summary>
    /// Interaction logic for App.xaml
    /// </summary>
    public partial class App : Application
    {
        // 多重起動禁止のロジックは
        //   http://akabeko.sakura.ne.jp/blog/2009/10/wpf-%E3%82%A2%E3%83%97%E3%83%AA%E3%81%AE%E8%B5%B7%E5%8B%95%E5%87%A6%E7%90%86/
        // を参考にした

        /// <summary>
        /// 多重起動禁止用mutex
        /// </summary>
        private static Mutex _mutex = null;

        /// <summary>
        /// Windows 10 Anniversary Update以降かどうかを判定
        /// </summary>
        /// <returns></returns>
        /// 
        private bool IsWin10AUorLater()
        {
            Version OSVer = Environment.OSVersion.Version;

            if (OSVer.Major > 10)
                return true;
            if (OSVer.Major == 10)
            {
                if (OSVer.Minor > 0)
                    return true;
                else
                    return (OSVer.Build >= 14393);
            }
            else
                return false;
        }

        [DllImport("kernel32.dll", SetLastError = true)]
        private static extern bool SetProcessShutdownParameters(uint dwLevel, uint dwFlags);

        private void Application_Startup(object sender, StartupEventArgs e)
        {
            //_ = MessageBox.Show(System.Runtime.InteropServices.RuntimeInformation.FrameworkDescription, "AyaClock.WPF");
            // .NET 8.0.xxxx

            // Windows 10 Anniversary Update以降のみサポート
            if (!IsWin10AUorLater())
            {
                _ = MessageBox.Show("AyaClock.WPF needs Windows 10 Anniversary Update or later", "AyaClock.WPF");
                this.Shutdown();
                return;
            }

            // 多重起動チェック
            App._mutex = new Mutex(false, "AyaClock.WPF2023.mutex");
            if (!App._mutex.WaitOne(0, false))
            {
                App._mutex.Close();
                App._mutex = null;
                _ = MessageBox.Show("AyaClock.WPF already exists", "AyaClock.WPF");
                this.Shutdown();
                return;
            }

            // END SESSION時のshutdown優先順位を上げておく(謎の例外対策……)
            uint shutdownLevel = 0x3FF; // 他のアプリよりちょっとだけ終了の優先順位を上げておく
            uint shutdownFlags = 0;     // フラグなし

            if (!SetProcessShutdownParameters(shutdownLevel, shutdownFlags))
            {
                // 失敗したとき？ とりあえず諦めて続行
                _ = MessageBox.Show("Failed SetProcessShutdownParameters Func", "AyaClock.WPF");
            }

            // 依存runtimeの名前とバージョンを取得 ver 0.12
            UpdateChecker.GetUsingRuntimeNames();
        }

        private void Application_Exit(object sender, ExitEventArgs e)
        {
            if (App._mutex != null)
            {
                App._mutex.ReleaseMutex();
                App._mutex.Close();
                App._mutex = null;
            }
        }
    }
}
