﻿using System;
using System.Drawing;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Interop;
using System.Runtime.InteropServices;
using Ayakawa.MonitorTools;

namespace Ayakawa.FormUtils
{
    /// <summary>
    /// 画面上の配置タイプ
    /// シリアライズを使ってセーブ・ロードするのでpublicにしておく
    /// </summary>
    public enum PositionType
    {
        LeftTop,
        LeftBottom,
        RightTop,
        RightBottom,
        Any
    }

    /// <summary>
    /// Windowの位置を調整する関数
    ///   AWindow  .......... 対象となるWindow
    ///   APosType .......... 配置する位置
    ///   AnIgnoreTaskBar ... Taskbarを無視するなら真
    /// 注意・XPでは常にTaskbarを無視する
    /// </summary>
    class FormUtils
    {
        //[SecurityPermission(SecurityAction.Demand, UnmanagedCode = true)]
        static public void AdjustWindowPos(Window AWindow, PositionType APosType, bool AnIgnoreTaskBar)
        {
            MONITORINFO mi = new MONITORINFO();
            HelperTools.GetMonitorInfoFromWindow(AWindow, MonitorDefaultTo.Nearest, ref mi);
            RECT taskTrayRc = new RECT();
            RECT realWARc = new RECT();
            if (AnIgnoreTaskBar)
            {
                // TaskBarを無視する場合
                realWARc = mi.rcMonitor;
            }
            else if (HelperTools.GetTaskBarRectFromWindow(AWindow, ref taskTrayRc))
            {
                // Taskbarの領域が取得出来たので、「正しい」workareaを取得
                int w = (mi.rcMonitor.left + mi.rcMonitor.right) / 2, h = (mi.rcMonitor.top + mi.rcMonitor.bottom) / 2;
                // Taskbarの位置を推定
                if (taskTrayRc.right < w)
                {
                    // Taskbarは左
                    mi.rcMonitor.left = taskTrayRc.right;
                }
                else if (taskTrayRc.left > w)
                {
                    // Taskbarは右
                    mi.rcMonitor.right = taskTrayRc.left;
                }
                else if (taskTrayRc.bottom < h)
                {
                    // Taskbarは上
                    mi.rcMonitor.top = taskTrayRc.bottom;
                }
                else
                {
                    // Taskbarは下
                    mi.rcMonitor.bottom = taskTrayRc.top;
                }
                realWARc = mi.rcMonitor;
            }
            else
            {
                // Taskbar領域が取得出来なかったので、mi.rcWorkをworkareaにする
                realWARc = mi.rcWork;
            }

            // 画面のDPIを参考にして調整
            uint dpiX = 0, dpiY = 0;
            HelperTools.GetDpiFromWindow(AWindow, MonitorDefaultTo.Nearest, MonitorDpiType.Effective, ref dpiX, ref dpiY);
            realWARc.left = (int)(realWARc.left * 96.0 / dpiX);
            realWARc.right = (int)(realWARc.right * 96.0 / dpiX);
            realWARc.top = (int)(realWARc.top * 96.0 / dpiY);
            realWARc.bottom = (int)(realWARc.bottom * 96.0 / dpiY);
            //
            switch (APosType)
            {
                case PositionType.LeftTop:
                    AWindow.Left = realWARc.left;
                    AWindow.Top = realWARc.top;
                    break;
                case PositionType.LeftBottom:
                    AWindow.Left = realWARc.left; 
                    AWindow.Top = realWARc.bottom - AWindow.Height;
                    break;
                case PositionType.RightTop:
                    AWindow.Left = realWARc.right - AWindow.Width;
                    AWindow.Top = realWARc.top;
                    break;
                case PositionType.RightBottom:
                    AWindow.Left = realWARc.right - AWindow.Width;
                    AWindow.Top = realWARc.bottom - AWindow.Height;
                    break;
                case PositionType.Any:
                    if ((AWindow.Left+AWindow.Width) >= realWARc.right) AWindow.Left = realWARc.right - AWindow.Width;
                    if ((AWindow.Top + AWindow.Height) >= realWARc.bottom) AWindow.Top = realWARc.bottom - AWindow.Height;
                    break;
            }
            // ウインドウが画面をはみ出していた時のフォロー
            if ((AWindow.Left + AWindow.Width) >= realWARc.right)
            {
                AWindow.Left = realWARc.right - AWindow.Width;
            }
            if (AWindow.Left < realWARc.left)
            {
                AWindow.Left = realWARc.left;
            }
            if ((AWindow.Top + AWindow.Height) >= realWARc.bottom)
            {
                AWindow.Top = realWARc.bottom - AWindow.Height;
            }
            if (AWindow.Top < realWARc.top)
            {
                AWindow.Top = realWARc.top;
            }
        }
    }
}
